package djdata_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	dataobj   openrtb3.Data
	dataobj25 openrtb.Data
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall data targeting criteria
func CheckDataCriteria(dataChannel chan []djgetad.GetAd, d int, data openrtb3.Data, data25 openrtb.Data, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			dataChannel <- filterads
		}
	}()
	if d == 1 {
		dataobj = data
	} else if d == 2 {
		dataobj25 = data25
	}
	
			validate_campaign := make(map[int]int)


	for _, ad := range ads {
		
				if validate_campaign[ad.Placement_id] == 1 {
			
			filterads = append(filterads, ad)
			continue
		}
		
		if validate_campaign[ad.Placement_id] == 2 {
			continue
		} 
		
		validate_campaign[ad.Placement_id] = 2 // by default not match 
		
		
		
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match
			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}
	dataChannel <- filterads
}

/* ------------------------------------------------------------------------------------
			Data Targetting Start(20/12/19)
---------------------------------------------------------------------------------------*/
// Dataname start
func (c Commander) MAX_checkClient_Dataname(cmd Command) bool {
	var reqDN string
	if dataobj.Name != "" {
		reqDN = dataobj.Name
	} else if dataobj25.Name != "" {
		reqDN = dataobj25.Name
	}
	argDN := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqDN != "" {
		if op == "=~" || op == "==" {
			return reqDN == argDN
		} else if op == "!=" || op == "!~" {
			return reqDN != argDN
		} else {
			return false
		}
	}
	return false
}

//Dataname end
/* ------------------------------------------------------------------------------------
			Data Targetting End(20/12/19)
---------------------------------------------------------------------------------------*/
